//
//  PurposeOptionsViewController.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 24.02.23.
//

import UIKit
import JNGradientLabel

class TransactionPurposeViewController : UIViewController, UITextFieldDelegate {
    
    @IBOutlet var topBarLabel: JNGradientLabel!
    
    @IBOutlet var purposeLabel: UILabel!
    @IBOutlet var purposeTextField: UITextField!
    
    @IBOutlet var continueButton: UIButton!
    @IBOutlet var backButton: UIButton!
    
    fileprivate var _kbSize:CGSize!
    
    @IBOutlet var wordCountLabel: UILabel!
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        UINavigationBar.appearance().titleTextAttributes = [.foregroundColor : UIColor.white,
                                                            .font : Fonts.mediumFontWithSize(size: 18)]
        
        // change button text if we returned from summary navigation controller, i.e., user wants to change a single field
        if(returnedFromTransactionSummaryView == true) {
            continueButton.setTitle("Übernehmen", for: .normal)
            backButton.isHidden = true
        }
        
        if transactionPurposePublic != "" {
            purposeTextField.text = transactionPurposePublic
            self.wordCountLabel.text = "\(self.purposeTextField.text!.count)/"+"\(50)"
        }
        
        // top bar gradient color
        let gradientColors: [UIColor]    = [UIColor(red: 47.0/255.0, green: 67.0/255.0, blue: 99.0/255.0, alpha: 1.0), UIColor(red: 67/255.0, green: 114.0/255.0, blue: 196.0/255.0, alpha: 1.0)]
        let gradientlocations: [CGFloat] = [1.0, 0.0]
        
        topBarLabel.textColor = .white
        topBarLabel.textGradientLocation = .background
        topBarLabel.setAxialGradientParameters(startPoint: CGPoint(x: 0.0, y: 0.0),
                                                                endPoint: CGPoint(x: 1.0, y: 1.0),
                                                                colors: gradientColors,
                                                                locations: gradientlocations)
        

        
        // style text field
        Utilities.styleTextField(purposeTextField)
        
        purposeLabel.font = Fonts.mediumFontWithSize(size: 17)
        
        purposeTextField.font = Fonts.mediumFontWithSize(size: 17)
        
        wordCountLabel.font = Fonts.mediumFontWithSize(size: 13)
        
        // open keyboard by default on view did load
        purposeTextField.becomeFirstResponder()
        
        // style continue button
        Utilities.styleFilledButtonAuthScreenGreenEdged(continueButton)
        continueButton.translatesAutoresizingMaskIntoConstraints = false
        
        continueButton.titleLabel?.font = Fonts.mediumFontWithSize(size: 17)

        //  Registering for keyboard notification.
         NotificationCenter.default.addObserver(self, selector: #selector(self.keyboardWillShow(_:)), name: UIResponder.keyboardWillShowNotification, object: nil)

        // https://stackoverflow.com/questions/30656501/how-to-do-a-live-uitextfield-count-while-typing-swift
        self.purposeTextField.delegate = self // required for character counter
        purposeTextField.addTarget(self, action: #selector(self.textFieldDidChange(textField:)), for: UIControl.Event.editingChanged)
        
    }
    
    // https://stackoverflow.com/questions/30656501/how-to-do-a-live-uitextfield-count-while-typing-swift
    @objc func textFieldDidChange(textField : UITextField){
        self.wordCountLabel.text = "\(self.purposeTextField.text!.count)/"+"\(50)"
      }
        
    
    
    
    @IBAction func backButton(_ sender: Any) {
        transactionPurposePublic = purposeTextField.text ?? ""
        
        let nc = self.storyboard?.instantiateViewController(withIdentifier: "TransactionAmountNC") as! UINavigationController
        
        nc.modalPresentationStyle = .fullScreen
        nc.modalTransitionStyle = .crossDissolve
        present(nc, animated: true)
    }
    
    @IBAction func continueButton(_ sender: Any) {
        transactionPurposePublic = purposeTextField.text ?? ""
        
        if(returnedFromTransactionSummaryView == true) {
            let nc = self.storyboard?.instantiateViewController(withIdentifier: "TransactionSummaryNC") as! UIViewController
            
            nc.modalPresentationStyle = .fullScreen
            nc.modalTransitionStyle = .coverVertical
            
            present(nc, animated: true)
        } else {
            let nc = self.storyboard?.instantiateViewController(withIdentifier: "TransactionSummaryNC") as! UIViewController
            
            nc.modalPresentationStyle = .fullScreen
            nc.modalTransitionStyle = .coverVertical
            
            present(nc, animated: true)
        }
    }
    
    
    @IBAction func deletePurposeTextButton(_ sender: Any) {
        purposeTextField.text = ""
        wordCountLabel.text = "0/50"
    }
    
    
    
    /*  UIKeyboardWillShowNotification. */
        @objc internal func keyboardWillShow(_ notification : Notification?) -> Void {
            
            
            
            if let info = notification?.userInfo {

                let frameEndUserInfoKey = UIResponder.keyboardFrameEndUserInfoKey
                
                //  Getting UIKeyboardSize.
                if let kbFrame = info[frameEndUserInfoKey] as? CGRect {
                    
                    let screenSize = UIScreen.main.bounds
                    
                    //Calculating actual keyboard displayed size, keyboard frame may be different when hardware keyboard is attached (Bug ID: #469) (Bug ID: #381)
                    let intersectRect = kbFrame.intersection(screenSize)
                    
                    if intersectRect.isNull {
                        _kbSize = CGSize(width: screenSize.size.width, height: 350) // default keyboard height = 350
                    } else {
                        _kbSize = intersectRect.size
                    }
                    print("Your Keyboard Size \(_kbSize)")
                    print(_kbSize.height)
                    //let rectCG = CGRect(x: 0, y: 0, width: 0, height: _kbSize.height)
                    continueButton.bottomAnchor.constraint(equalTo: view.bottomAnchor, constant: -(_kbSize.height)-10).isActive = true
                }
            }
        }
    
}

// https://stackoverflow.com/questions/30656501/how-to-do-a-live-uitextfield-count-while-typing-swift
extension TransactionPurposeViewController {
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        if !(textField.text?.isEmpty ?? true){
            return textField.text!.count +  (string.count - range.length) <= 50
        }
        return true
    }
}
